/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.authentication;

/**
 * Representation of an OAuth2 JWT Token authentication
 */
public class JwtTokenAuthenticationInfo implements AuthenticationInfo {

	private final String token;

	public JwtTokenAuthenticationInfo(String token) {
		this.token = token;
	}

	/**
	 * @return the OAuth2 JWT Token
	 */
	public String getToken() {
		return token;
	}

}
