/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.draft;

import com.sap.cds.Result;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} for the {@link DraftService#EVENT_DRAFT_GC} event.
 */
@EventName(DraftService.EVENT_DRAFT_GC)
public interface DraftGcEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be {@link DraftService#EVENT_DRAFT_GC}
	 * @return the {@link DraftGcEventContext}
	 */
	static DraftGcEventContext create() {
		return EventContext.create(DraftGcEventContext.class, null);
	}

	@Override
	DraftService getService();

	Result getResult();

	void setResult(Result result);

}
