package com.sap.cds.services.environment;

import java.util.stream.Stream;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;

/**
 * Provides properties, service bindings and other configuration options.
 */
public interface CdsEnvironment {

   /*
	* @return The {@link CdsProperties} the {@link CdsRuntime} was initialized with
	*/
   CdsProperties getCdsProperties();

   /**
	* Returns the value of the property with given key as given type {@code asClazz}.
	* Returns the specified default value if key is not existing.
	*
	* @param <T> the type of the property value
	* @param key	The key of the property
	* @param asClazz The type of the property value
	* @param defaultValue The default value if the key is not present
	* @return	The property value or {@code defaultValue} if not defined
	*/
   <T> T getProperty(String key, Class<T> asClazz, T defaultValue);

	/**
	 * @return The available {@link ServiceBinding}s from the {@link ServiceBindingProvider} registered on the {@link CdsRuntime}
	 */
	Stream<ServiceBinding> getServiceBindings();

	/**
	 * @return The {@link ApplicationInfo} from the {@link ApplicationInfoProvider} registered on the {@link CdsRuntime}
	 */
	ApplicationInfo getApplicationInfo();

}
