/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.environment;

import java.util.List;
import java.util.Map;

/**
 * An Open Service Broker API service binding
 * 
 * @deprecated Use {@link com.sap.cloud.environment.servicebinding.api.ServiceBinding} instead.
 */
@Deprecated(since = "2.0.0")
public interface ServiceBinding {

	/**
	 * @return the name of the service binding or if not available the service instance
	 */
	String getName();

	/**
	 * @return the name of the service
	 */
	String getService();

	/**
	 * @return the service plan
	 */
	String getServicePlan();

	/**
	 * @return the list of tags
	 */
	List<String> getTags();

	/**
	 * @return the credentials
	 */
	Map<String, Object> getCredentials();

	/**
	 *
	 * Returns true, if a service binding matches the given tag filter or service filter.
	 *
	 * The tag filter is used first to match the service binding.
	 * It is only used if the given tag filter is not {@code null} and if the service binding has a non-empty tag list ({@link #getTags()}).
	 * If the tag filter is used and no tag match can be found the serviceFilter is applied.
	 *
	 * If the tag filter is not used or has a negative result an additional service filter is applied against the service name of the binding.
	 * It is only applied if the given service filter is not {@code null}.
	 *
	 * @param tagFilter the tag to match the tags against.
	 * @param serviceFilter the service name to match the service against.
	 * @return true, if the service binding matches, false otherwise
	 */
	default boolean matches(String tagFilter, String serviceFilter) {
		boolean tagsMatched = false;
		if (tagFilter != null && getTags() != null && !getTags().isEmpty()) {
			tagsMatched = getTags().contains(tagFilter);
		}
		return tagsMatched || (serviceFilter != null ? serviceFilter.equals(getService()) : false);
	}

}
