/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.handler.annotations;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Annotation to define the order of event handler methods within an event phase
 */
@Target({ METHOD })
@Retention(RUNTIME)
@Documented
public @interface HandlerOrder {

	/**
	 * Order value to execute the event handler method before other event handlers
	 */
	int EARLY = -10000; // -10000 ... -4999

	/**
	 * The default order value
	 */
	int DEFAULT = 0; // -5000 ... 4999

	/**
	 * Order value to execute the event handler method after other event handlers
	 */
	int LATE = 10000; // 5000 ... 10000

	/**
	 * @return The order value.
	 */
	int value();

	/**
	 * Steps to define the order sequence between event handler methods
	 */
	int BEFORE = -100;

	int AFTER = 100;

}
