/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.handler.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.sap.cds.services.Service;

/**
 * Annotation to be used on class level to specify the default {@link Service}, which should be used when registering annotation-based handlers.
 * If no name is given either via this annotation or via the <code>service</code> attribute of the {@link Before}, {@link On} or {@link After} annotation registration of the handler fails.
 */
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface ServiceName {

	/**
	 * Returns the names of the {@link Service} the handlers of this class should be registered on
	 * If no name is given either via this annotation or via the <code>service</code> attribute of the {@link Before}, {@link On} or {@link After} annotation registration of the handler fails.
	 *
	 * @return the name of the {@link Service} the handlers of this class should be registered on
	 */
	String[] value();

	/**
	 * Returns the array of service types the handler wants to handle.
	 * This can be used together with a service name '*' to register on all services of certain types.
	 * If no type is given, all service types will be considered
	 * <br>
	 * Defaults to an empty array
	 *
	 * @return the array of service types the handler wants to handle
	 */
	Class<? extends Service>[] type() default {};

}
