/**************************************************************************
 * (C) 2019-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.messaging;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import com.sap.cds.services.ServiceException;

/**
 * {@link EventContext} for the event {@link MessagingService#EVENT_MESSAGING_ERROR}, that
 * allows to handle acknowledgement of a message on the messaging channel
 */
@EventName(MessagingService.EVENT_MESSAGING_ERROR)
public interface MessagingErrorEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be {@link MessagingService#EVENT_MESSAGING_ERROR}
	 * @return the {@link MessagingErrorEventContext}
	 */
	static MessagingErrorEventContext create() {
		MessagingErrorEventContext context = EventContext.create(MessagingErrorEventContext.class, null);
		// in order to avoid handling the error event as a messaging event by the messaging service we mark the error event as inbound
		context.put("isInbound", true);
		return context;
	}

	/**
	 * Sets the {@link ServiceException} that was thrown while handling the message.
	 * @param exception the {@link ServiceException} that was thrown while handling the message.
	 */
	void setException(ServiceException exception);

	/**
	 * @return the {@link ServiceException} that caused the error during the message handling.
	 */
	ServiceException getException();

	/**
	 * Determines whether the message should be acknowledged or not.
	 * @param acknowledge <code>true</code> if the message should be acknowledged on the messaging channel and <code>false</code> otherwise.
	 */
	void setResult(boolean acknowledge);

	/**
	 * @return <code>true</code> if the message should be acknowledged on the messaging channel and <code>false</code> otherwise.
	 */
	boolean getResult();



}
