/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.List;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} for the {@link TenantProviderService#EVENT_READ_TENANTS} event.
 */
@EventName(TenantProviderService.EVENT_READ_TENANTS)
public interface ReadTenantsEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The event is set to be {@link TenantProviderService#EVENT_READ_TENANTS}
	 * @return the {@link ReadTenantsEventContext}
	 */
	static ReadTenantsEventContext create() {
		return EventContext.create(ReadTenantsEventContext.class, null);
	}

	@Override
	TenantProviderService getService();

	/**
	 * @return A list of tenant identifiers that are currently subscribed to this application.
	 */
	List<TenantInfo> getResult();

	/**
	 * @param result A list of tenant identifiers that are currently subscribed to this application.
	 */
	void setResult(List<TenantInfo> result);

}
