package com.sap.cds.services.mt;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;

/**
 * Tenant info
 */
public interface TenantInfo extends CdsData {

	/**
	 * Creates a new {@link TenantInfo}
	 * @return the {@link TenantInfo}
	 */
	static TenantInfo create() {
		return Struct.create(TenantInfo.class);
	}

	/**
	 * @return the tenant identifier
	 */
	String getTenant();

	/**
	 * Sets the tenant identifier
	 * @param tenant the tenant identifier
	 */
	void setTenant(String tenant);
}
