/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.outbox;

import com.sap.cds.services.Service;

/**
 * Defines the outbox service API. The outbox can be used to couple emitting of
 * events on a service to the currently active transaction.
 *
 * The following applies when using the outbox:
 * - The outbox message is stored in the outbox.
 * - If the transaction fails, the outbox message is not stored in the outbox and is never emitted.
 * - A persisted outbox message is emitted eventually (asynchronously or synchronously, depending on the outbox implementation)
 *
 */
public interface OutboxService extends Service {

	public static final String IS_OUTBOXED = "IS_OUTBOXED";

	public static final String PERSISTENT_NAME = "OutboxService$Persistent";

	public static final String INMEMORY_NAME = "OutboxService$InMemory";

	/**
	 * Stores the given message under the given target event in the outbox.
	 *
	 * @param targetEvent the target event with which the message is stored and again published by the {@link OutboxService}
	 * @param message the outbox message stored and again published by the {@link OutboxService}
	 */
	public void enroll(String targetEvent, String message);

}
