/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.pdf;

import java.io.OutputStream;
import java.util.Map;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} used for the {@link PdfService#EVENT_EXPORT} event.
 */
@EventName(PdfService.EVENT_EXPORT)
public interface PdfExportEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlayed with this interface. The
	 * event is set to be {@link PdfService#EVENT_EXPORT}
	 * 
	 * @return the {@link PdfExportEventContext}
	 */
	static PdfExportEventContext create() {
		return EventContext.create(PdfExportEventContext.class, null);
	}

	/**
	 * @return data to be exported
	 */
	Iterable<? extends Map<String, ?>> getData();

	/**
	 * @param data data to be exported
	 */
	void setData(Iterable<? extends Map<String, ?>> data);

	/**
	 * @return PDF document description
	 */
	PdfDocumentDescription getDocumentDescription();

	/**
	 * @param desc PDF document description
	 */
	void setDocumentDescription(PdfDocumentDescription desc);

	/**
	 * @return output stream to wrtie to
	 */
	OutputStream getOutputStream();

	/**
	 * @param out output stream to wrtie to
	 */
	void setOutputStream(OutputStream out);
}
