/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.request;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ExtendedServiceLoader;

/**
 * Interface to access {@link RequestContext} objects. It's preferred to use it via {@link RequestContext#getCurrent(CdsRuntime)}.
 * The implementation of the factory is loaded via {@link ExtendedServiceLoader} and is therefore pluggable.
 */
public interface RequestContextAccessor {

	/**
	 * @return true, if a {@link RequestContext} is currently active
	 */
	boolean isActive();

	/**
	 * Gives access to either the current {@link RequestContext},
	 * or if this does not exist to a helper {@link RequestContext} that itself ensures that there is always a {@link RequestContext} opened.
	 * This method will throw a {@link NullPointerException}, if the passed {@link CdsRuntime} was null, but guarantees that it will never return <code>null</code>
	 *
	 * @param runtime A reference to the underlying {@link CdsRuntime} instance.
	 * @return the current {@link RequestContext} or a helper {@link RequestContext}
	 */
	RequestContext getCurrent(CdsRuntime runtime);

}
