package com.sap.cds.services.runtime;

/**
 * Can be implemented by classes loaded through {@link ExtendedServiceLoader}.
 * It allows access to the {@link CdsRuntime} for which the class was loaded through the {@link #setCdsRuntime(CdsRuntime)} method.
 * This method is called directly after object creation through Java's standard {@link java.util.ServiceLoader}.
 */
public interface CdsRuntimeAware {

	/**
	 * Provides access to the {@link CdsRuntime}.
	 * It is called directly after the object was created.
	 *
	 * @param runtime the {@link CdsRuntime}
	 */
	void setCdsRuntime(CdsRuntime runtime);

}
