/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.transaction;

import com.sap.cds.services.changeset.ChangeSetMember;

/**
 * A {@link ChangeSetMember} wrapper for a given {@link TransactionManager}
 */
public class ChangeSetMemberDelegate implements ChangeSetMember {

	private final TransactionManager txMgr;

	public ChangeSetMemberDelegate(TransactionManager txMgr) {
		this.txMgr = txMgr;
	}

	@Override
	public String getName() {
		return txMgr.getName();
	}

	@Override
	public void cancel() {
		txMgr.rollback();
	}

	@Override
	public void complete() {
		txMgr.commit();
	}

	@Override
	public boolean isMarkedForCancel() {
		return txMgr.isRollbackOnly();
	}

}
