/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.auditlog;

import java.time.Instant;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * Data modification interface for logging successful and
 * unsuccessful modification to any sensitive personal data.
 */
@EventName("dataModificationLog")
public interface DataModificationLogContext extends EventContext {
	String CDS_NAME = "dataModificationLog";

	@Override
	AuditLogService getService();

	DataModificationLog getData();

	void setData(DataModificationLog event);

	Instant getCreatedAt();

	void setCreatedAt(Instant createdAt);

	static DataModificationLogContext create() {
		return EventContext.create(DataModificationLogContext.class, null);
	}
}
