/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.auditlog;

import java.util.Collection;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

/**
 * The object where the accessed or modified personal data that
 * is being audit logged is contained.
 */
@CdsName("com.sap.cds.services.auditlog.Object")
public interface DataObject extends CdsData {
  String TYPE = "type";

  String ID = "id";

  /**
   * The object type.
   */
  String getType();

  /**
   * The object type.
   */
  void setType(String type);

  /**
   * The unique object identifier.
   */
  Collection<KeyValuePair> getId();

  /**
   * The unique object identifier.
   */
  void setId(Collection<KeyValuePair> id);

  static DataObject create() {
    return Struct.create(DataObject.class);
  }
}
