/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.auditlog;

import java.util.Collection;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

/**
 * The data subject whom the accessed personal data that is
 * being audit logged belongs to.
 */
@CdsName("com.sap.cds.services.auditlog.DataSubject")
public interface DataSubject extends CdsData {
  String TYPE = "type";

  String ID = "id";

  String ROLE = "role";

  /**
   * Type to the data subject
   */
  String getType();

  /**
   * Type to the data subject
   */
  void setType(String type);

  Collection<KeyValuePair> getId();

  void setId(Collection<KeyValuePair> id);

  /**
   * Role to the data subject.
   */
  String getRole();

  /**
   * Role to the data subject.
   */
  void setRole(String role);

  static DataSubject create() {
    return Struct.create(DataSubject.class);
  }
}
