/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.runtime;

public interface CdsProvider<T extends CdsProvider<T>> {

	/**
	 * Passes the latest configured provider during configuration phase when this instances gets registered.
	 * The previous provider can be used to build an adapted provider on top.
	 * @param previous	The previously registered provider.
	 */
	default void setPrevious(T previous) {
	}

}
