/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.runtime;

import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;

/**
 * A {@link UserInfoProvider} provides the {@link UserInfo} for a {@link RequestContext} if not provided explicitly.
 * It can get access to the determined {@link AuthenticationInfo} from the {@link AuthenticationInfoProvider} through {@link CdsRuntime#getProvidedAuthenticationInfo()}.
 */
public interface UserInfoProvider extends CdsProvider<UserInfoProvider> {

	/**
	 * Provides the {@link UserInfo}.
	 *
	 * @return	the {@link UserInfo} if available, {@code null} otherwise.
	 */
	UserInfo get();

}
