/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.transaction;

/**
 * Interface to abstract on {@link TransactionManager} instances provided by different frameworks.
 * The {@link TransactionManager} provides the ability to start and to commit or rollback transactions.
 */
public interface TransactionManager {

	/**
	 * The name of the {@link TransactionManager}. It needs to be unique among all transaction managers.
	 * @return the name of the {@link TransactionManager}
	 */
	String getName();

	/**
	 * @return true, if a transaction is currently active
	 */
	boolean isActive();

	/**
	 * Starts a new transaction
	 */
	void begin();

	/**
	 * Commits the current transaction
	 */
	void commit();

	/**
	 * Rollbacks the current transaction
	 */
	void rollback();

	/**
	 * @return true, if the transaction was marked as rollback only
	 */
	boolean isRollbackOnly();

	/**
	 * Marks the transaction as rollback only
	 */
	void setRollbackOnly();
}
