/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.runtime;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ExtendedServiceLoader {
    public static <T> Iterator<T> loadAll(Class<T> clazz) {
        return ExtendedServiceLoader.loadAll(clazz, null);
    }

    public static <T> Iterator<T> loadAll(Class<T> clazz, CdsRuntime runtime) {
        Iterator<T> iterator = ServiceLoader.load(clazz).iterator();
        ArrayList runtimeAware = new ArrayList();
        iterator.forEachRemaining(i -> {
            if (i instanceof CdsRuntimeAware) {
                CdsRuntimeAware aware = (CdsRuntimeAware)i;
                if (runtime == null) {
                    throw new IllegalStateException("Cannot provide CdsRuntime to implementation for " + clazz.getCanonicalName());
                }
                aware.setCdsRuntime(runtime);
            }
            runtimeAware.add(i);
        });
        return runtimeAware.iterator();
    }

    public static <T> T loadSingle(Class<T> clazz) {
        return ExtendedServiceLoader.loadSingle(clazz, null);
    }

    public static <T> T loadSingle(Class<T> clazz, CdsRuntime runtime) {
        Iterator<T> iterator = ExtendedServiceLoader.loadAll(clazz, runtime);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        throw new IllegalStateException("Cannot find implementation for " + clazz.getCanonicalName());
    }
}

