/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.MessageTarget;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.slf4j.helpers.MessageFormatter;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected final ErrorStatus errorStatus;
    private final MessageLookup messageLookup;
    private String longTextUrl;
    private MessageTarget messageTarget;
    private List<MessageTarget> additionalTargets = List.of();
    private boolean isTransition = true;
    protected final Object[] args;
    protected static ServiceExceptionUtils Utils = CoreFactory.INSTANCE.createServiceExceptionUtils();

    public ServiceException(Throwable e) {
        this(null, e.getMessage(), e);
    }

    public ServiceException(String messageOrKey, Object ... args) {
        this(null, messageOrKey, args);
    }

    public ServiceException(ErrorStatus errorStatus, String messageOrKey, Object ... args) {
        super(messageOrKey);
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate((Object[])args);
        if (throwableCandidate != null) {
            super.initCause(throwableCandidate);
            this.args = MessageFormatter.trimmedCopy((Object[])args);
        } else {
            this.args = args;
        }
        this.errorStatus = errorStatus;
        this.messageLookup = MessageLookup.create(messageOrKey, this.args);
    }

    @Override
    public String getMessage() {
        return Utils.getMessage(this.getPlainMessage(), this.args);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(null);
    }

    public String getLocalizedMessage(Locale locale) {
        return Utils.getLocalizedMessage(this.getPlainMessage(), this.args, locale, true);
    }

    public String getPlainMessage() {
        return super.getMessage();
    }

    public List<EventContext> getEventContexts() {
        List contexts = this.getNearest(ServiceException::collectEventContexts);
        return contexts == null ? Collections.emptyList() : Collections.unmodifiableList(contexts);
    }

    protected List<EventContext> collectEventContexts() {
        return null;
    }

    private <T> T getNearest(Function<ServiceException, T> provider) {
        T value = provider.apply(this);
        for (Throwable cause = this.getCause(); value == null && cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ServiceException)) continue;
            ServiceException exception = (ServiceException)cause;
            value = provider.apply(exception);
        }
        return value;
    }

    public ErrorStatus getErrorStatus() {
        ErrorStatus theErrorStatus = this.getNearest(e -> e.errorStatus);
        return theErrorStatus == null ? ErrorStatuses.SERVER_ERROR : theErrorStatus;
    }

    public MessageLookup getMessageLookup() {
        return this.messageLookup;
    }

    public String getLongTextUrl() {
        return this.getNearest(e -> e.longTextUrl);
    }

    public MessageTarget getMessageTarget() {
        return this.getNearest(e -> e.messageTarget);
    }

    public List<MessageTarget> getAdditionalTargets() {
        return this.getNearest(e -> e.additionalTargets);
    }

    public boolean isTransition() {
        return this.getNearest(e -> e.isTransition);
    }

    public ServiceException longTextUrl(String longTextUrl) {
        this.longTextUrl = longTextUrl;
        return this;
    }

    public ServiceException transition(boolean isTransition) {
        this.isTransition = isTransition;
        return this;
    }

    public ServiceException messageTarget(MessageTarget target) {
        this.messageTarget = target;
        return this;
    }

    public ServiceException messageTarget(String target) {
        return this.messageTarget(MessageTarget.create(target));
    }

    public ServiceException messageTarget(Function<StructuredType<?>, Object> path) {
        return this.messageTarget(MessageTarget.create(path));
    }

    public ServiceException messageTarget(String parameter, Function<StructuredType<?>, Object> path) {
        return this.messageTarget(MessageTarget.create(parameter, path));
    }

    public <E extends StructuredType<E>> ServiceException messageTarget(Class<E> type, Function<E, Object> path) {
        return this.messageTarget(MessageTarget.create(type, path));
    }

    public <E extends StructuredType<E>> ServiceException messageTarget(String parameter, Class<E> type, Function<E, Object> path) {
        return this.messageTarget(MessageTarget.create(parameter, type, path));
    }

    public ServiceException messageTarget(Path path, CdsElement element) {
        return this.messageTarget(MessageTarget.create(path, element));
    }

    public ServiceException additionalTargets(List<MessageTarget> additionalTargets) {
        this.additionalTargets = additionalTargets;
        return this;
    }

    public ServiceException additionalTargets(MessageTarget ... additionalTargets) {
        return this.additionalTargets(List.of(additionalTargets));
    }
}

