/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.time.Instant;

@EventName("configChangeLog")
public interface ConfigChangeLogContext extends EventContext {
  String CDS_NAME = "configChangeLog";

  @Override
  AuditLogService getService();

  ConfigChangeLog getData();

  void setData(ConfigChangeLog event);

  Instant getCreatedAt();

  void setCreatedAt(Instant createdAt);

  static ConfigChangeLogContext create() {
    return EventContext.create(ConfigChangeLogContext.class, null);
  }
}
