/*
 * © 2021-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.auditlog;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.time.Instant;

/**
 * Data access interface for logging successful and unsuccessful access to any sensitive personal
 * data.
 */
@EventName("dataAccessLog")
public interface DataAccessLogContext extends EventContext {
  String CDS_NAME = "dataAccessLog";

  @Override
  AuditLogService getService();

  DataAccessLog getData();

  void setData(DataAccessLog event);

  Instant getCreatedAt();

  void setCreatedAt(Instant createdAt);

  static DataAccessLogContext create() {
    return EventContext.create(DataAccessLogContext.class, null);
  }
}
