/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.authentication;

/** Representation of a Basic authentication */
public class BasicAuthenticationInfo implements AuthenticationInfo {

  private final String username;
  private final String password;

  public BasicAuthenticationInfo(String username, String password) {
    this.username = username;
    this.password = password;
  }

  /**
   * @return the basic authentication username
   */
  public String getUsername() {
    return username;
  }

  /**
   * @return the basic authentication password
   */
  public String getPassword() {
    return password;
  }
}
