/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.changeset;

import com.sap.cds.services.runtime.ExtendedServiceLoader;

/**
 * Interface to access {@link ChangeSetContext} objects. It's preferred to use it via {@link
 * ChangeSetContext#getCurrent()}. The implementation of the factory is loaded via {@link
 * ExtendedServiceLoader} and is therefore pluggable.
 */
public interface ChangeSetContextAccessor {

  /**
   * @return true, if a {@link ChangeSetContext} is currently active
   */
  boolean isActive();

  /**
   * Gives access to the currently active {@link ChangeSetContext}. If no {@link ChangeSetContext}
   * is currently opened this method will return <code>null</code>
   *
   * @return the currently active {@link ChangeSetContext} or <code>null</code>.
   */
  ChangeSetContext getCurrent();
}
