/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.Map;

/** The {@link EventContext} for the {@link DraftService#EVENT_DRAFT_CANCEL} event. */
@EventName(DraftService.EVENT_DRAFT_CANCEL)
public interface DraftCancelEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link DraftService#EVENT_DRAFT_CANCEL}
   *
   * @param entityName the name of the entity
   * @return the {@link DraftCancelEventContext}
   */
  static DraftCancelEventContext create(String entityName) {
    return EventContext.create(DraftCancelEventContext.class, entityName);
  }

  @Override
  DraftService getService();

  // IN
  /**
   * @return the {@link CqnDelete} statement
   */
  CqnDelete getCqn();

  /**
   * Sets the {@link CqnDelete} statement
   *
   * @param cqn the {@link CqnDelete} statement
   */
  void setCqn(CqnDelete cqn);

  /**
   * @return the CQN value sets, to enable batched {@link CqnDelete} statements
   */
  Iterable<Map<String, Object>> getCqnValueSets();

  /**
   * Sets the CQN value sets, to enable batched {@link CqnDelete} statements
   *
   * @param valueSets the CQN value sets
   */
  void setCqnValueSets(Iterable<Map<String, Object>> valueSets);

  // OUT
  /**
   * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_CANCEL} event
   */
  Result getResult();

  /**
   * Sets the result of the {@link DraftService#EVENT_DRAFT_CANCEL} event
   *
   * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link
   *     Result}
   */
  void setResult(Iterable<? extends Map<String, ?>> result);
}
