/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.draft;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;
import java.util.Map;

/** The {@link EventContext} for the {@link DraftService#EVENT_DRAFT_PATCH} event. */
@EventName(DraftService.EVENT_DRAFT_PATCH)
public interface DraftPatchEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link DraftService#EVENT_DRAFT_PATCH}
   *
   * @param entityName the name of the entity
   * @return the {@link DraftPatchEventContext}
   */
  static DraftPatchEventContext create(String entityName) {
    return EventContext.create(DraftPatchEventContext.class, entityName);
  }

  @Override
  DraftService getService();

  // IN
  /**
   * @return the {@link CqnUpdate} statement
   */
  CqnUpdate getCqn();

  /**
   * Sets the {@link CqnUpdate} statement
   *
   * @param cqn the {@link CqnUpdate} statement
   */
  void setCqn(CqnUpdate cqn);

  /**
   * @return the CQN value sets, to enable batched {@link CqnUpdate} statements
   */
  Iterable<Map<String, Object>> getCqnValueSets();

  /**
   * Sets the CQN value sets, to enable batched {@link CqnUpdate} statements
   *
   * @param valueSets the CQN value sets
   */
  void setCqnValueSets(Iterable<Map<String, Object>> valueSets);

  // OUT
  /**
   * @return the {@link Result} of the {@link DraftService#EVENT_DRAFT_PATCH} event
   */
  Result getResult();

  /**
   * Sets the result of the {@link DraftService#EVENT_DRAFT_PATCH} event
   *
   * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link
   *     Result}
   */
  void setResult(Iterable<? extends Map<String, ?>> result);
}
