/*
 * © 2019-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.messages;

import com.sap.cds.services.runtime.CdsProvider;
import java.util.Locale;
import org.slf4j.helpers.MessageFormatter;

/**
 * A {@code LocalizedMessageProvider} is capable to build localized messages based on string formats
 * in the application's resource bundles.
 */
public interface LocalizedMessageProvider extends CdsProvider<LocalizedMessageProvider> {

  /**
   * Returns the localized message for the given code, arguments and locale if existing, {@code
   * null} otherwise. The method does not throw and returns {@code code} in case of any errors.
   *
   * @param messageOrKey The formatting message, based on SLF4J's {@link MessageFormatter}, or a key
   *     to a message format in the resource bundles.
   * @param args The argument objects for the format string.
   * @param locale The locale to be used. If no locale is set the default locale is taken.
   * @return The localized message or {@code null} if the code is not resolvable.
   */
  String get(String messageOrKey, Object[] args, Locale locale);
}
