/*
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.services.mt;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} for the {@link TenantProviderService#EVENT_READ_PROVIDER_TENANT} event.
 */
@EventName(TenantProviderService.EVENT_READ_PROVIDER_TENANT)
public interface ReadProviderTenantEventContext extends EventContext {

  /**
   * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
   * {@link TenantProviderService#EVENT_READ_PROVIDER_TENANT}
   *
   * @return the {@link ReadProviderTenantEventContext}
   */
  static ReadProviderTenantEventContext create() {
    return EventContext.create(ReadProviderTenantEventContext.class, null);
  }

  @Override
  TenantProviderService getService();

  /**
   * @return The tenant identifier of the tenant that provides this application.
   */
  String getResult();

  /**
   * @param providerTenant The tenant identifier of the tenant that provides this application.
   */
  void setResult(String providerTenant);
}
