| Property | Type | Default Value | Description |
| --- | --- | --- | --- |
| **cds.environment** |  |  | Properties for environments, like local development or Cloud Foundry. |
| **cds.environment.local** |  |  | Properties for the local environment. |
| `cds.environment.local.defaultEnvPath` | `String` |  | Specification of the default environment JSON file. If this property starts with<br>"classpath:", it is read as classloader resource. Otherwise it is interpreted as<br>file-system path. The file content follows the structure of Cloud Foundry's VCAP_SERVICES<br>and VCAP_APPLICATION environment variables. If this property specifies a folder, the<br>filename `default-env.json` is appended to it. |
| **cds.environment.production** |  |  | Properties for the production environment. |
| `cds.environment.production.profile` | `String` | `cloud` | The Spring Boot profile to attach production-optimized default property values to. |
| `cds.environment.production.enabled` | `boolean` |  | Determines, if it is enabled. |
| **cds.environment.deployment** |  |  | Properties for the specific application deployment. |
| `cds.environment.deployment.version` | `String` |  | The version of the application deployment in format x.y.z-qualifier. It is expected, that<br>application deployments can be sorted semantically by this version. |
| **cds.dataSource** |  |  | Properties for the primary data source, used by the default persistence service. |
| `cds.dataSource.embedded` | `boolean` | `false` | Determines, if the data source is considered embedded (in-memory). |
| `cds.dataSource.binding` | `String` |  | The name of the primary service binding, used by the default persistence service. |
| **cds.dataSource.csv** |  |  | Properties for CSV initialization. |
| `cds.dataSource.csv.initializationMode` | `String` | `embedded` | Determines in which scenarios the default persistence service is initialized with CSV data.<br>By default, CSV initialization only happens, if the data source is embedded (in-memory).<br>Possible values are: `embedded`, `never`, `always`. |
| `cds.dataSource.csv.fileSuffix` | `String` | `.csv` | The file suffix of CSV files. |
| `cds.dataSource.csv.paths` | `List<String>` | `db/data/**, db/csv/**, ../db/data/**, ../db/csv/**` | The file-system paths to search for CSV files in. Using `/**` at the end of the path<br>triggers a recursive search. |
| `cds.dataSource.csv.singleChangeset` | `boolean` | `false` | Enables import of all CSV files in a single changeset. By default, each CSV file is<br>imported in a separate changeset. |
| **cds.dataSource.autoConfig** |  |  | Properties to control the `DataSource` auto-configuration from service bindings. |
| `cds.dataSource.autoConfig.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.model** |  |  | Properties for the CDS model. |
| `cds.model.csnPath` | `String` | `edmx/csn.json` | The resource path to the `csn.json` file. |
| `cds.model.includeUiAnnotations` | `boolean` | `false` | Determines, if UI annotations are included in the model. |
| **cds.model.provider** |  |  | The model provider configuration. |
| `cds.model.provider.url` | `String` |  | The URL of the Model Provider. |
| `cds.model.provider.extensibility` | `boolean` | `true` | Assume that dynamic models contain tenant-specific extensions. |
| `cds.model.provider.toggles` | `boolean` | `true` | Assume that dynamic models are feature-toggle specific. |
| **cds.model.provider.cache** |  |  | Properties for the CDS model and EDMX metadata caches. |
| `cds.model.provider.cache.maxSize` | `int` | `20` | The number of entries in the CDS model and EDMX metadata caches. |
| `cds.model.provider.cache.expirationTime` | `int` | `600` | The lifetime of an entry in seconds after the entry's creation, the most recent<br>replacement of its value, or its last access. |
| `cds.model.provider.cache.refreshTime` | `int` | `60` | The time in seconds after which a cached entry is refreshed. |
| **cds.security** |  |  | Properties for security configurations of services and endpoints. |
| `cds.security.logPotentiallySensitive` | `boolean` | `false` | Determines, if potentially sensitive data, for example values in CQN queries, might be<br>logged. |
| **cds.security.authentication** |  |  | Properties for authentication in general. |
| `cds.security.authentication.mode` | `String` | `model-strict` | Determines the mode that is used when authenticating endpoints of protocol-adapters.<br>Possible values are: - never: No endpoint requires authentication - model-relaxed:<br>Authentication is derived from @requires/@restrict, defaults to public endpoints. -<br>model-strict: Authentication is derived from @requires/@restrict, defaults to authenticated<br>endpoints. - always: All endpoints require authentication |
| `cds.security.authentication.authenticateMetadataEndpoints` | `boolean` | `true` | Determines, if OData $metadata endpoints enforce authentication. |
| `cds.security.authentication.authenticateUnknownEndpoints` | `boolean` | `true` | Determines, if security configurations enforce authentication for endpoints not managed by<br>protocol-adapters. |
| `cds.security.authentication.normalizeProviderTenant` | `boolean` | `true` | Determines, if the provider tenant is normalized to `null`. |
| `cds.security.authentication.clientCertificateHeader` | `String` | `X-Forwarded-Client-Cert` | Header name for forwarded client certificates. |
| **cds.security.authentication.authConfig** |  |  | Properties for the Spring security auto-configuration. |
| `cds.security.authentication.authConfig.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.authentication.internalUserAccess** |  |  | Determines of internal users are allowed to access endpoints offered for callbacks by reuse<br>services (e.g. SMS, SaaSRegistry, UCL) * |
| `cds.security.authentication.internalUserAccess.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.authorization** |  |  | Properties for authorization. |
| `cds.security.authorization.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.authorization.draftProtection** |  |  | Properties to control the protection of drafts. If a draft is protected, it is only<br>accessible by its creator. |
| `cds.security.authorization.draftProtection.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.identity** |  |  | Properties for authentication based on Identity Service (IAS). |
| `cds.security.identity.binding` | `String` |  | The name of the IAS service binding, used for the identity security auto-configuration and<br>MTXs sidecar communication. |
| `cds.security.identity.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.xsuaa** |  |  | Properties for authentication based on XSUAA. |
| `cds.security.xsuaa.binding` | `String` |  | The name of the XSUAA service binding, used for the XSUAA security auto-configuration and<br>MTXs sidecar communication. |
| `cds.security.xsuaa.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.mock** |  |  | Properties for authentication based on mock-users. |
| `cds.security.mock.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.mock.users** |  |  | The mock-users, used for basic authentication in local development and test scenarios. The<br>key can be chosen arbitrarily and is used as the user name, if the `name` property is not<br>explicitly defined. In addition it can be leveraged to split configuration across multiple<br>profiles. |
| `cds.security.mock.users.<key>.id` | `String` |  | The ID of the mock-user. |
| `cds.security.mock.users.<key>.name` | `String` |  | The (mandatory) name of the mock-user. It's used to perform the basic authentication. |
| `cds.security.mock.users.<key>.password` | `String` |  | The (optional) password of the mock-user. It's used to perform the basic authentication. |
| `cds.security.mock.users.<key>.tenant` | `String` |  | The tenant of the mock-user. |
| `cds.security.mock.users.<key>.systemUser` | `boolean` | `false` | Determines, if this mock-user is treated as a system user. |
| `cds.security.mock.users.<key>.privileged` | `boolean` | `false` | Determines, if this mock-user is treated as the privileged user. |
| `cds.security.mock.users.<key>.internalUser` | `boolean` | `false` | Determines, if this mock-user is treated as the internal user. |
| `cds.security.mock.users.<key>.roles` | `List<String>` |  | The list of roles, that are assigned to this mock-user. |
| `cds.security.mock.users.<key>.features` | `List<String>` |  | The list of enabled feature toggles for this user. If set, it overrules features of the<br>tenant (if provided). |
| `cds.security.mock.users.<key>.attributes` | `Map<String,List<String>>` |  | A map of user attributes, that are assigned to the mock-user. The name of the attribute<br>needs to be given as the key. The attribute values are provided as a list. |
| `cds.security.mock.users.<key>.additional` | `Map<String,Object>` |  | A map of additional properties of the mock-user. It can be used to mock authentication<br>specific properties (e.g. email address). The name of the additional attribute needs to<br>be given as the key. The value of the attribute can be provided as an arbitrary object. |
| `cds.security.mock.users.<key>.policies` | `List<String>` |  | A list of AMS policies associated with the mock-user. |
| **cds.security.mock.defaultUsers** |  |  | Enables a list of default mock-users. |
| `cds.security.mock.defaultUsers.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.security.mock.tenants** |  |  | The tenants in local development and test scenarios. The key can be chosen arbitrarily and<br>is used as the tenant name, if the `name` property is not explicitly defined. In addition<br>it can be leveraged to split configuration across multiple profiles. |
| `cds.security.mock.tenants.<key>.name` | `String` |  | The (mandatory) name of the tenant |
| `cds.security.mock.tenants.<key>.features` | `List<String>` |  | The list of enabled feature toggles for this tenant. |
| **cds.indexPage** |  |  | Properties for the index page. |
| `cds.indexPage.path` | `String` | `/` | The base-path of the adapter endpoint. |
| `cds.indexPage.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV4** |  |  | Properties for the OData V4 protocol adapter. |
| `cds.odataV4.contextAbsoluteUrl` | `boolean` | `false` | Determines, if URLs in the @odata.context response annotation are absolute. |
| `cds.odataV4.edmxPath` | `String` | `edmx/v4` | The JAR resource path to search for OData V4 EDMX files. |
| `cds.odataV4.searchMode` | `String` | `odata-lenient` | Defines the handling of the $search query option. In `odata-strict` mode the search string is<br>parsed and interpreted according to the OData v4 $search specification. In `pass-through`<br>mode the search string is passed through to the data store. In `odata-lenient` mode the<br>search string is parsed and only passed through on parsing errors. |
| **cds.odataV4.endpoint** |  |  | Properties of the OData V4 protocol adapter endpoint. |
| `cds.odataV4.endpoint.path` | `String` | `/odata/v4` | The base-path of the adapter endpoint. |
| `cds.odataV4.endpoint.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV4.fioriPreview** |  |  | Properties for the Fiori Preview on the index page. |
| `cds.odataV4.fioriPreview.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV4.fioriPreview.ui5** |  |  | Properties for the UI5 dependency used for the Fiori Preview. |
| `cds.odataV4.fioriPreview.ui5.version` | `String` |  |  |
| `cds.odataV4.fioriPreview.ui5.host` | `String` | `https://sapui5.hana.ondemand.com` |  |
| **cds.odataV4.lazyI18n** |  |  | Determines, if localization is applied to the EDMX lazily, saving memory resources. |
| `cds.odataV4.lazyI18n.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV4.batch** |  |  | Properties for OData batch requests. |
| `cds.odataV4.batch.maxRequests` | `long` | `-1` | Defines the maximum number of requests within OData batch requests. By default, no limit<br>applies. |
| **cds.odataV2** |  |  | Properties for the OData V2 protocol adapter. |
| `cds.odataV2.edmxPath` | `String` | `edmx/v2` | The JAR resource path to search for OData V2 EDMX files. |
| `cds.odataV2.caseSensitiveFilter` | `boolean` | `true` | Determines whether OData functions 'substringof', 'startswith' and 'endswith' are<br>case-sensitive. |
| `cds.odataV2.searchMode` | `String` | `odata-lenient` | Defines the handling of the $search query option. In `odata-strict` mode the search string is<br>parsed and interpreted according to the OData v4 $search specification. In `pass-through`<br>mode the search string is passed through to the data store. In `odata-lenient` mode the<br>search string is parsed and only passed through on parsing errors. |
| **cds.odataV2.endpoint** |  |  | Properties of the OData V2 protocol adapter endpoint. |
| `cds.odataV2.endpoint.path` | `String` | `/odata/v2` | The base-path of the adapter endpoint. |
| `cds.odataV2.endpoint.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.odataV2.batch** |  |  | Properties for OData batch requests. |
| `cds.odataV2.batch.maxRequests` | `long` | `-1` | Defines the maximum number of requests within OData batch requests. By default, no limit<br>applies. |
| **cds.hcql** |  |  | Properties for the HCQL protocol adapter. |
| **cds.hcql.endpoint** |  |  | Properties of the HCQL protocol adapter endpoint. |
| `cds.hcql.endpoint.path` | `String` | `/hcql` | The base-path of the adapter endpoint. |
| `cds.hcql.endpoint.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.messaging** |  |  | Properties for messaging services. |
| **cds.messaging.webhooks** |  |  | Properties for receiving messages through the webhook. |
| `cds.messaging.webhooks.url` | `String` |  | The application webhook URL. This URL is used when registering the webhook at the message<br>broker. |
| `cds.messaging.webhooks.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.messaging.routes** |  |  | The list of routes for the composite messaging service. The first route that matches is used.<br>Therefore the order of these routes has significance. |
| `cds.messaging.routes.<index>.service` | `String` |  | The target service of the route. |
| `cds.messaging.routes.<index>.events` | `List<String>` |  | The list of events/topics, which are propagated to/from the target service. |
| **cds.messaging.services** |  |  | Properties for messaging services. The key can be chosen arbitrarily and is used as the<br>messaging service name, if the `name` property is not explicitly defined. In addition it can<br>be leveraged to split configuration across multiple profiles. |
| `cds.messaging.services.<key>.name` | `String` |  | The name of the messaging service. |
| `cds.messaging.services.<key>.kind` | `String` |  | The kind of the messaging service. It usually reflects the corresponding service binding<br>type. Possible values are: `local-messaging`, `file-based-messaging`,<br>`enterprise-messaging`, `message-queuing`, `redis-pubsub`, `kafka-channel-messaging`. |
| `cds.messaging.services.<key>.binding` | `String` |  | The name of the service binding used for this messaging service. In case of<br>file-based-messaging this specifies the file-system path to the exchange file. |
| `cds.messaging.services.<key>.subscribePrefix` | `String` |  | The string used to prefix topics when subscribing to events. |
| `cds.messaging.services.<key>.publishPrefix` | `String` |  | The string used to prefix topics when publishing events. |
| `cds.messaging.services.<key>.format` | `String` |  | The message format to be assumed on subscriptions and applied when publishing. Possible<br>values are: `cloudevents` |
| `cds.messaging.services.<key>.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.messaging.services.\<key\>.connection** |  |  | Properties for the JMS client connection. |
| `cds.messaging.services.<key>.connection.dedicated` | `boolean` | `false` | Determines, if this messaging service uses its own dedicated JMS client connection. By<br>default, JMS client connections to the same messaging broker are shared. |
| `cds.messaging.services.<key>.connection.properties` | `Map<String,String>` |  | Properties passed to the JMS client connection. The possible keys and values depend on<br>the messaging service implementation. |
| **cds.messaging.services.\<key\>.queue** |  |  | Properties of the queue that is created for the messaging service. |
| `cds.messaging.services.<key>.queue.name` | `String` |  | The name of the queue. The queue may already exist with some custom configuration. In<br>that case the queue is not recreated. |
| `cds.messaging.services.<key>.queue.config` | `Map<String,Object>` |  | Properties passed to the messaging broker when creating the queue. The possible keys and<br>values depend on the messaging service implementation. |
| `cds.messaging.services.<key>.queue.subscriptions` | `List<String>` |  | A list of additional topics, that are subscribed on the queue. By default event handler<br>registrations should be used to trigger subscriptions. This property is intended for<br>purposes when subscriptions can not be inferred from event handler registrations. |
| `cds.messaging.services.<key>.queue.forceListening` | `boolean` | `false` | Specifies whether a queue listener should be connected even if no subscription is<br>available. |
| **cds.messaging.services.\<key\>.outbox** |  |  | Properties to control, if and how the Outbox should be used for this messaging service. |
| `cds.messaging.services.<key>.outbox.name` | `String` | `DefaultOutboxOrdered` | The name of the outbox service to use. If not available or set, the in-memory outbox is<br>used as fallback. |
| `cds.messaging.services.<key>.outbox.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.multiTenancy** |  |  | Properties for multitenancy and extensibility. |
| `cds.multiTenancy.componentScan` | `String` |  | Package to be included in the component scan of the Subscribe, Deploy and Unsubscribe main<br>methods. |
| **cds.multiTenancy.endpoint** |  |  | Properties of the subscription HTTP endpoints. |
| `cds.multiTenancy.endpoint.path` | `String` | `/mt/v1.0/subscriptions` | The base-path of the adapter endpoint. |
| `cds.multiTenancy.endpoint.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.multiTenancy.subscriptionManager** |  |  | Properties for the subscription manager service. |
| **cds.multiTenancy.subscriptionManager.endpoint** |  |  | Properties of the subscription HTTP endpoint for Subscription Manager Service (SMS). |
| `cds.multiTenancy.subscriptionManager.endpoint.path` | `String` | `/mt/sms/subscriptions` | The base-path of the adapter endpoint. |
| `cds.multiTenancy.subscriptionManager.endpoint.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.multiTenancy.dataSource** |  |  | Properties for the multitenant aware datasource. |
| `cds.multiTenancy.dataSource.pool` | `String` | `hikari` | Pool to use for the multitenant-aware datasource. Possible values are: `hikari`, `tomcat`. |
| `cds.multiTenancy.dataSource.hanaEncryptionMode` | `String` |  | Optional tenant encryption mode used by the HANA database. Possible values are<br>DEDICATED_KEY and MANAGED_KEY. |
| **cds.multiTenancy.dataSource.combinePools** |  |  | Properties to control how the connection pools are maintained. This allows to configure,<br>that the connection pools for tenants contained in the same database are combined. Instead<br>of having a dedicated connection pool for each tenant schema. |
| `cds.multiTenancy.dataSource.combinePools.enabled` | `boolean` | `false` | Determines, if it is enabled. |
| **cds.multiTenancy.serviceManager** |  |  | Properties for the service-manager client. |
| `cds.multiTenancy.serviceManager.cacheRefreshInterval` | `Duration` | `PT2M` | The cache refresh interval (as Duration). |
| `cds.multiTenancy.serviceManager.tokenRetrievalTimeout` | `Duration` | `PT30S` | The oauth token retrieval timeout (as Duration). |
| **cds.multiTenancy.serviceManager.v2** |  |  |  |
| `cds.multiTenancy.serviceManager.v2.enabled` | `boolean` | `false` | Determines, if it is enabled. |
| **cds.multiTenancy.security** |  |  | Properties for authorization. |
| `cds.multiTenancy.security.subscriptionScope` | `String` | `mtcallback` | The scope by which the subscription endpoints are authorized. |
| **cds.multiTenancy.sidecar** |  |  | Properties for the MTX sidecar client. |
| `cds.multiTenancy.sidecar.url` | `String` |  | The URL of the MTX sidecar. Setting this property, in combination with a present<br>service-manager service binding, activates the MTX features. |
| `cds.multiTenancy.sidecar.pollingTimeout` | `Duration` | `PT20M` | Specifies the maximum waiting time for the operation to finish. |
| **cds.multiTenancy.appUi** |  |  | Properties for the URL to the application's UI endpoints. |
| `cds.multiTenancy.appUi.url` | `String` |  | The URL to the application's UI, used for the 'Go to Application' link. |
| `cds.multiTenancy.appUi.tenantSeparator` | `String` |  | The separator for the tenant in the URL. Possible values are: `.`, `-`. |
| **cds.multiTenancy.healthCheck** |  |  | Properties for health check of the multitenant-aware datasource. |
| `cds.multiTenancy.healthCheck.healthCheckStatement` | `String` |  | The statement that is used when executing a health check of the multitenant-aware<br>datasource. |
| `cds.multiTenancy.healthCheck.interval` | `Duration` | `PT10S` | The time a health check result is cached and no further health checks are performed. |
| `cds.multiTenancy.healthCheck.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.multiTenancy.liquibase** |  |  | Properties for DB lifecycle management via Liquibase. |
| `cds.multiTenancy.liquibase.changeLog` | `String` | `/db/changelog/db.changelog-master.yaml` | The location of the master Liquibase file. |
| `cds.multiTenancy.liquibase.contexts` | `String` |  | Optional: Comma separated list of active contexts. |
| **cds.multiTenancy.provisioning** |  |  | Properties for the ProvisioningService from @sap/cds-mtxs. |
| `cds.multiTenancy.provisioning.url` | `String` |  | URL of the provisioning service. If not specified, `cds.multitenancy.sidecar.url` is taken<br>as default. |
| `cds.multiTenancy.provisioning.pollingTimeout` | `Duration` | `PT10M` | Specifies the maximum waiting time for the provisioning operation to finish. |
| **cds.multiTenancy.mock** |  |  | Properties for the SQLite-based MTX mock for local development and testing. |
| `cds.multiTenancy.mock.sqliteDirectory` | `String` |  | Path to the directory to start looking for SQLite database files. |
| `cds.multiTenancy.mock.enabled` | `boolean` |  | Determines, if it is enabled. |
| **cds.multiTenancy.dependencies** |  |  | Properties for automatically reported subscription dependencies. |
| `cds.multiTenancy.dependencies.destination` | `boolean` | `false` | Indicates if a subscription dependency should be registered for a bound service instance of<br>Destination service. |
| `cds.multiTenancy.dependencies.portal` | `boolean` | `true` | Indicates if a subscription dependency should be registered for a bound service instance of<br>Portal service. |
| `cds.multiTenancy.dependencies.html5AppsRepo` | `boolean` | `true` | Indicates if a subscription dependency should be registered for a bound service instance of<br>html5-app-repo service. |
| **cds.persistence** |  |  | Properties for persistence services. |
| **cds.persistence.services** |  |  | Properties for persistence services. The key can be chosen arbitrarily and is used as the<br>persistence service name, if the `name` property is not explicitly defined. In addition it<br>can be leveraged to split configuration across multiple profiles. |
| `cds.persistence.services.<key>.name` | `String` |  | The name of the persistence service. |
| `cds.persistence.services.<key>.binding` | `String` |  | The name of the service binding used for this persistence service. If not set, the name is<br>used. |
| `cds.persistence.services.<key>.dataSource` | `String` |  | The name of the existing data source. If not set, the auto-configured data source of the<br>binding is used. |
| `cds.persistence.services.<key>.transactionManager` | `String` |  | The name of the existing transaction manager. If not set, the transaction manager is<br>automatically created. |
| `cds.persistence.services.<key>.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.persistence.changeSet** |  |  | Properties for ChangeSetContexts. |
| `cds.persistence.changeSet.enforceTransactional` | `boolean` | `true` | Determines, if a `ChangeSetContext` should be always marked as transactional. Setting this<br>to `false` allows avoiding transactions for Select queries. |
| **cds.application** |  |  | Properties for application services. |
| **cds.application.services** |  |  | Properties for application services. The key can be chosen arbitrarily and is used as the<br>application service name, if the `name` property is not explicitly defined. In addition it<br>can be leveraged to split configuration across multiple profiles. |
| `cds.application.services.<key>.name` | `String` |  | The name of the application service. |
| `cds.application.services.<key>.model` | `String` |  | The qualified name of the CDS service, which is the model definition of this application<br>service. It defaults to the name of the application service itself. |
| **cds.application.services.\<key\>.serve** |  |  | Properties to configure how this service is served by protocol adapters. |
| `cds.application.services.<key>.serve.ignore` | `boolean` | `false` | Determines, if the service is ignored by protocol adapters. |
| `cds.application.services.<key>.serve.path` | `String` |  | The path this service should be served at by protocol adapters. The path is appended to<br>the protocol adapter's base path. If a service is served by multiple protocol adapters,<br>each adapter serves the service under this path. |
| `cds.application.services.<key>.serve.protocols` | `List<String>` |  | The list of protocols adapters this service should be served by. By default the service<br>is served by all available protocol adapters. Possible values are: `odata-v4`,<br>`odata-v2`. |
| **cds.application.services.\<key\>.serve.endpoints** |  |  | Properties to control more fine-grained under which endpoints this service is served.<br>These properties override the more general properties `paths` and `protocols`. |
| `cds.application.services.<key>.serve.endpoints.<index>.path` | `String` |  | The path, this endpoint should be served at by the protocol adapter. The path is<br>appended to the protocol adapter's base path. |
| `cds.application.services.<key>.serve.endpoints.<index>.protocol` | `String` |  | The protocol adapter that serves this endpoint. Possible values are: `odata-v4`,<br>`odata-v2`. |
| **cds.remote** |  |  | Properties for remote services. |
| **cds.remote.services** |  |  | Properties for remote services. The key can be chosen arbitrarily and is used as the<br>application service name, if the `name` property is not explicitly defined. In addition it<br>can be leveraged to split configuration across multiple profiles. |
| `cds.remote.services.<key>.name` | `String` |  | The name of the remote service. |
| `cds.remote.services.<key>.model` | `String` |  | The qualified name of the CDS service, which is the model definition of this remote<br>service. It defaults to the name of the remote service itself. |
| `cds.remote.services.<key>.type` | `String` | `odata-v4` | The protocol type of the destination. Possible values are: `odata-v4`, `odata-v2` and<br>`hcql`. |
| **cds.remote.services.\<key\>.http** |  |  | Properties to configure http requests for this remote service. |
| `cds.remote.services.<key>.http.suffix` | `String` |  | A suffix for the remote service, that is appended to the remote service's URL. |
| `cds.remote.services.<key>.http.service` | `String` |  | The name of the modelled service, that is appended to the remote service's URL (after the<br>suffix). It defaults to the qualified name of the model definition. |
| `cds.remote.services.<key>.http.headers` | `Map<String,String>` |  | A map of headers and their values, to be added to every outgoing request. |
| `cds.remote.services.<key>.http.queries` | `Map<String,String>` |  | A map of query parameters and their values, to be added to every outgoing request. |
| **cds.remote.services.\<key\>.http.csrf** |  |  | Properties to configure CSRF token requests for this service. |
| `cds.remote.services.<key>.http.csrf.enabled` | `boolean` | `false` | Determines, if it is enabled. |
| **cds.remote.services.\<key\>.destination** |  |  | Properties to configure a remote destination for this remote service. |
| `cds.remote.services.<key>.destination.name` | `String` |  | The name of the destination in the destination service or SAP Cloud SDK destination<br>accessor. |
| `cds.remote.services.<key>.destination.properties` | `Map<String,Object>` |  | A map of generic destination properties supported by SAP Cloud SDK. These properties are<br>used to dynamically build a destination. |
| `cds.remote.services.<key>.destination.retrievalStrategy` | `String` |  | The retrieval strategy used, when loading destinations from SAP BTP Destination Service.<br>See<br>https://sap.github.io/cloud-sdk/docs/java/features/connectivity/sdk-connectivity-destination-service#retrieval-strategy-options<br>for possible values. |
| `cds.remote.services.<key>.destination.tokenExchangeStrategy` | `String` |  | The token exchange strategy used, when loading destinations from SAP BTP Destination<br>Service. See<br>https://sap.github.io/cloud-sdk/docs/java/features/connectivity/sdk-connectivity-destination-service#token-exchange-options<br>for possible values. |
| **cds.remote.services.\<key\>.binding** |  |  | Properties to configure a service binding for this remote service. * |
| `cds.remote.services.<key>.binding.name` | `String` |  | The name of the service binding which provides the credentials. |
| `cds.remote.services.<key>.binding.onBehalfOf` | `String` | `currentUser` | Determines the user and tenant context that is used. Possible values are: `currentUser`,<br>`systemUser` and `systemUserProvider` |
| `cds.remote.services.<key>.binding.options` | `Map<String,String>` |  | A map of additional options that are used to enrich the used service binding. The<br>supported options depend on the type of service binding that is used. Possible options<br>are: `url` for service bindings of type `xsuaa` |
| **cds.locales** |  |  | Properties for locale configurations. |
| **cds.locales.normalization** |  |  | Properties to configure how locales should be normalized. |
| `cds.locales.normalization.defaults` | `boolean` | `true` | Determines, if the non-normalization include list, as described in the documentation, is<br>applied. |
| `cds.locales.normalization.includeList` | `List<String>` |  | The list of additional locales to add to the include list of non-normalized locales. |
| **cds.errors** |  |  | Properties for error handling. |
| `cds.errors.extended` | `boolean` | `false` | Determines, if error messages are automatically extended with additional debug information<br>(only for development). |
| `cds.errors.combined` | `boolean` | `true` | Determines, if validation error messages are collected and exceptions are thrown at the end<br>of the Before event handler phase. |
| **cds.errors.stackMessages** |  |  | Properties to configure how error messages from the framework are treated. If turned off,<br>only framework error messages, that are explicitly localized are returned. Other errors are<br>mapped to their plain HTTP error code representation. |
| `cds.errors.stackMessages.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.errors.defaultTranslations** |  |  | Properties to configure how default translations from the framework are used. |
| `cds.errors.defaultTranslations.enabled` | `boolean` | `false` | Determines, if it is enabled. |
| **cds.drafts** |  |  | Properties for draft-enabled entities. |
| `cds.drafts.cancellationTimeout` | `Duration` | `PT15M` | The maximum amount of time, since the last change, an entity instance is locked by the user<br>who is editing its draft version. |
| `cds.drafts.deletionTimeout` | `Duration` | `PT720H` | The maximum amount of time a draft is kept, before it is garbage collected. |
| `cds.drafts.persistence` | `String` | `joint` | Determines the persistence mode for draft-enabled entities. In case of `joint` persistence<br>queries with JOINs between databases tables/views of active instances and databases tables of<br>draft instances can occur. If set to `split` such queries are avoided. Possible values are:<br>`joint`, `split`. |
| **cds.drafts.gc** |  |  | Properties to configure the automatic draft garbage collection. |
| `cds.drafts.gc.interval` | `Duration` | `PT6H` | The interval, in which the automatic draft garbage collection is triggered. |
| `cds.drafts.gc.maxPause` | `Duration` | `PT5M` | The max duration the draft GC timer task pauses in between processing GCs of different<br>tenants. |
| `cds.drafts.gc.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.query** |  |  | Properties for augmentation of CQN queries. |
| **cds.query.limit** |  |  | Properties for server-driven paging. |
| `cds.query.limit.default` | `int` | `0` | The default page size for server-driven paging. Setting this property to 0 or -1 disables<br>the default page size. |
| `cds.query.limit.max` | `int` | `1000` | The maximum page size for server-driven paging. Setting this property to 0 or -1 disables<br>the maximum page size. |
| **cds.query.limit.reliablePaging** |  |  | Properties for reliable server-driven paging, based on last row of ordered result. |
| `cds.query.limit.reliablePaging.enabled` | `boolean` | `false` | Determines, if it is enabled. |
| **cds.query.implicitSorting** |  |  | Properties for the implicit-sorting feature. |
| `cds.query.implicitSorting.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.sql** |  |  | Properties for SQL generation. * |
| `cds.sql.maxBatchSize` | `int` | `1000` | The JDBC batch size used for batch and bulk operations. |
| **cds.sql.hana** |  |  | Configuration properties for an SQL generation on SAP HANA. |
| `cds.sql.hana.ignoreLocale` | `boolean` | `false` | If set to `true`, this property completely disables locale specific handling on SAP HANA. |
| `cds.sql.hana.optimizationMode` | `String` | `hex` | Sets the optimization mode for SAP HANA. The mode `hex` generates SQL that is optimized<br>exclusively for the HANA Cloud HEX engine. The mode `legacy` generates SQL, which is not<br>optimized for the HEX engine and can also run on SAP HANA 2.x (HaaS). |
| **cds.sql.hana.search** |  |  | Properties for search on SAP HANA Cloud. |
| `cds.sql.hana.search.fuzzy` | `boolean` | `false` | If set to `true`, fuzzy search on SAP HANA Cloud is activated. Requires<br>`cds.sql.hana.optimizationMode: hex` |
| `cds.sql.hana.search.fuzzinessThreshold` | `BigDecimal` | `0.8` | The least level of fuzziness, searchable elements need to have to be considered in a<br>fuzzy search. The value can be in the inclusive range of 0 to 1, where 1 means no<br>fuzziness (exact search). |
| **cds.sql.inlineCount** |  |  | Configuration properties for an SQL generation related to inline count. |
| `cds.sql.inlineCount.mode` | `String` | `auto` | Sets the inline-count mode. Possible values are: `auto`, `window-function` and `query` |
| **cds.auditLog** |  |  | Properties for AuditLog configuration. * |
| **cds.auditLog.v2** |  |  | Configuration of the AuditLog V2 feature. |
| `cds.auditLog.v2.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.auditLog.personalData** |  |  | Configuration of the Personal Data handler. |
| `cds.auditLog.personalData.throwOnMissingDataSubject` | `boolean` | `true` | If set to {@code true} and the data subject is missing, a `ServiceException` is thrown. |
| `cds.auditLog.personalData.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.auditLog.personalData.logRead** |  |  | If set to {@code true}, audit logging of access to sensitive personal data is enabled. |
| `cds.auditLog.personalData.logRead.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.auditLog.outbox** |  |  | Properties to configure AuditLog usage of Outbox. |
| `cds.auditLog.outbox.name` | `String` | `DefaultOutboxUnordered` | The name of the outbox service to use. If not available or set, the in-memory outbox is<br>used as fallback. |
| `cds.auditLog.outbox.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.auditLog.connectionPool** |  |  | Properties to configure the HTTP connection pool for AuditLog usage. |
| `cds.auditLog.connectionPool.maxConnections` | `Integer` | `200` | The max amount of connections in the pool. |
| `cds.auditLog.connectionPool.maxConnectionsPerRoute` | `Integer` | `20` | The max amount of connections from the pool per route |
| `cds.auditLog.connectionPool.timeout` | `Duration` | `PT1M` | The threshold for connect timeout, socket timeout and connection request timeout. |
| **cds.auditLog.connectionPool.combinePools** |  |  | Properties to control how the http connection pools are maintained. This allows to configure,<br>whether all tenants will share a common http connection pool instead of having a dedicated<br>http connection pool for each tenant. |
| `cds.auditLog.connectionPool.combinePools.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.outbox** |  |  | Properties for Outbox configuration. * |
| **cds.outbox.inMemory** |  |  | Properties for the in-memory Outbox. |
| `cds.outbox.inMemory.emitDuringChangeSetContext` | `boolean` | `false` | Specifies whether the outbox emits the event during the current `ChangeSetContext` or<br>afterwards. In case the `ChangeSetContext` wraps a DB transaction, it needs to be<br>considered that emitted messages during the transaction can't be rolled back on cancelled<br>transaction. Messages being emitted after the transaction might get lost, after transaction<br>has been committed successful. |
| `cds.outbox.inMemory.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.outbox.persistent** |  |  | Properties for the persistent Outbox. |
| `cds.outbox.persistent.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.outbox.services** |  |  | Properties for Outbox services. The key can be chosen arbitrarily and is used as the outbox<br>service name, if the `name` property is not explicitly defined. In addition it can be<br>leveraged to split configuration across multiple profiles. |
| `cds.outbox.services.<key>.name` | `String` |  | The name of the Outbox service. |
| `cds.outbox.services.<key>.maxAttempts` | `int` | `10` | Specifies the maximum number of attempts to emit a message stored in the Outbox. Messages<br>that have reached the maximum number of attempts are ignored by the Outbox and need to be<br>handled by the application. |
| `cds.outbox.services.<key>.ordered` | `boolean` | `true` | Controls how messages are published by the outbox. If set to `true`, the messages are<br>sequentially published exactly in the order they were stored in the Outbox. If set to<br>`false`, the messages are allowed to be published in random order and in parallel. |
| `cds.outbox.services.<key>.observable` | `boolean` | `true` | Controls whether the outbox records telemetry information for observability purposes. |
| `cds.outbox.services.<key>.checkVersion` | `boolean` | `true` | Determines, if message versions are checked to avoid processing newer messages in older<br>application deployments. |
| `cds.outbox.services.<key>.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.outbox.services.\<key\>.storeLastError** |  |  | Controls storing the error message of the last error in the Outbox. |
| `cds.outbox.services.<key>.storeLastError.enabled` | `boolean` | `true` | Determines, if it is enabled. |
| **cds.taskScheduler** |  |  | Properties for the Task Scheduler. |
| `cds.taskScheduler.enabled` | `boolean` | `false` | Determines, if it is enabled. |
