/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services.messages;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.messages.MessageLookup;
import com.sap.cds.services.messages.MessageTarget;
import java.util.List;
import java.util.function.Function;

public interface Message {
    public static Message create(Severity severity, String text) {
        return CoreFactory.INSTANCE.createMessage(severity, text);
    }

    public static Message create(Severity severity, String text, Message message) {
        return CoreFactory.INSTANCE.createMessage(severity, text, message);
    }

    public static Message create(String text, ServiceException exception) {
        return CoreFactory.INSTANCE.createMessage(text, exception);
    }

    public String getMessage();

    public MessageLookup getMessageLookup();

    public String getCode();

    public MessageTarget getTarget();

    public List<MessageTarget> getAdditionalTargets();

    public String getLongTextUrl();

    public boolean isTransition();

    public Severity getSeverity();

    public Message longTextUrl(String var1);

    public Message code(String var1);

    public Message transition(boolean var1);

    public Message target(MessageTarget var1);

    default public Message target(String target) {
        return this.target(MessageTarget.create(target));
    }

    default public Message target(Function<StructuredType<?>, Object> path) {
        return this.target(MessageTarget.create(path));
    }

    default public Message target(String parameter, Function<StructuredType<?>, Object> path) {
        return this.target(MessageTarget.create(parameter, path));
    }

    default public <E extends StructuredType<E>> Message target(Class<E> type, Function<E, Object> path) {
        return this.target(MessageTarget.create(type, path));
    }

    default public <E extends StructuredType<E>> Message target(String parameter, Class<E> type, Function<E, Object> path) {
        return this.target(MessageTarget.create(parameter, type, path));
    }

    default public Message target(Path path, CdsElement element) {
        return this.target(MessageTarget.create(path, element));
    }

    public Message additionalTargets(List<MessageTarget> var1);

    default public Message additionalTargets(MessageTarget ... additionalTargets) {
        return this.additionalTargets(List.of(additionalTargets));
    }

    public static enum Severity {
        SUCCESS(1),
        INFO(2),
        WARNING(3),
        ERROR(4);

        private final int numericSeverity;

        private Severity(int numericSeverity) {
            this.numericSeverity = numericSeverity;
        }

        public int getNumericSeverity() {
            return this.numericSeverity;
        }
    }
}

