/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.services;

import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.Path;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceExceptionUtils;
import com.sap.cds.services.messages.MessageTarget;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.slf4j.helpers.MessageFormatter;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected final ErrorStatus errorStatus;
    protected MessageTarget messageTarget;
    protected final Object[] args;
    protected static ServiceExceptionUtils Utils = CoreFactory.INSTANCE.createServiceExceptionUtils();

    public ServiceException(Throwable e) {
        this(null, e.getMessage(), e);
    }

    public ServiceException(String message, Object ... args) {
        this(null, message, args);
    }

    public ServiceException(ErrorStatus errorStatus, String message, Object ... args) {
        super(message);
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate((Object[])args);
        if (throwableCandidate != null) {
            super.initCause(throwableCandidate);
            this.args = MessageFormatter.trimmedCopy((Object[])args);
        } else {
            this.args = args;
        }
        this.errorStatus = errorStatus;
    }

    public ErrorStatus getErrorStatus() {
        ErrorStatus theErrorStatus = this.getNearest(e -> e.errorStatus);
        return theErrorStatus == null ? ErrorStatuses.SERVER_ERROR : theErrorStatus;
    }

    public MessageTarget getMessageTarget() {
        return this.getNearest(e -> e.messageTarget);
    }

    @Override
    public String getMessage() {
        return Utils.getMessage(this.getPlainMessage(), this.args);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(null);
    }

    public String getLocalizedMessage(Locale locale) {
        return Utils.getLocalizedMessage(this.getPlainMessage(), this.args, locale);
    }

    public String getPlainMessage() {
        return super.getMessage();
    }

    public List<EventContext> getEventContexts() {
        List contexts = this.getNearest(ServiceException::collectEventContexts);
        return contexts == null ? Collections.emptyList() : Collections.unmodifiableList(contexts);
    }

    protected List<EventContext> collectEventContexts() {
        return null;
    }

    private <T> T getNearest(Function<ServiceException, T> provider) {
        T value = provider.apply(this);
        for (Throwable cause = this.getCause(); value == null && cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ServiceException)) continue;
            ServiceException exception = (ServiceException)cause;
            value = provider.apply(exception);
        }
        return value;
    }

    public ServiceException messageTarget(String target) {
        return this.messageTarget(Utils.getMessageTarget(target));
    }

    public ServiceException messageTarget(MessageTarget target) {
        this.messageTarget = target;
        return this;
    }

    public ServiceException messageTarget(Function<StructuredType<?>, Object> path) {
        return this.messageTarget("cqn", path);
    }

    public ServiceException messageTarget(String parameter, Function<StructuredType<?>, Object> path) {
        this.messageTarget = Utils.getMessageTarget(parameter, path);
        return this;
    }

    public <E extends StructuredType<E>> ServiceException messageTarget(Class<E> type, Function<E, Object> path) {
        return this.messageTarget("cqn", type, path);
    }

    public <E extends StructuredType<E>> ServiceException messageTarget(String parameter, Class<E> type, Function<E, Object> path) {
        this.messageTarget = Utils.getMessageTarget(parameter, type, path);
        return this;
    }

    public ServiceException messageTarget(Path path, CdsElement element) {
        this.messageTarget = Utils.getMessageTarget(path, element);
        return this;
    }
}

