/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.authorization;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(AuthorizationService.EVENT_ACTION_ACCESS)
public interface ActionAccessEventContext extends EventContext {

	static ActionAccessEventContext create() {
		return EventContext.create(ActionAccessEventContext.class, null);
	}

	@Override
	AuthorizationService getService();

	// IN
	void setActionName(String actionName);

	String getActionName();

	void setEntityName(String event);

	String getEntityName(); // optional

	// OUT
	Boolean getResult();

	void setResult(boolean result);
}
