/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.cds;

import java.util.Map;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The specialized {@link EventContext} to be used for {@link CqnService#EVENT_DELETE}
 */
@EventName(CqnService.EVENT_DELETE)
public interface CdsDeleteEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlaid with this interface. The event is set to be {@link CqnService#EVENT_DELETE}
	 * @param entityName the name of the entity
	 * @return the {@link CdsDeleteEventContext}
	 */
	static CdsDeleteEventContext create(String entityName) {
		return EventContext.create(CdsDeleteEventContext.class, entityName);
	}

	@Override
	CqnService getService();

	// IN
	/**
	 * @return the {@link CqnDelete} statement
	 */
	CqnDelete getCqn();

	/**
	 * Sets the {@link CqnDelete} statement
	 * @param cqn the {@link CqnDelete} statement
	 */
	void setCqn(CqnDelete cqn);

	/**
	 * @return the CQN value sets, to enable batched {@link CqnDelete} statements
	 */
	Iterable<Map<String, Object>> getCqnValueSets();

	/**
	 * Sets the CQN value sets, to enable batched {@link CqnDelete} statements
	 * @param valueSets the CQN value sets
	 */
	void setCqnValueSets(Iterable<Map<String, Object>> valueSets);

	// OUT
	/**
	 * @return the {@link Result} of the {@link CqnService#EVENT_DELETE} event
	 */
	Result getResult();

	/**
	 * Sets the result of the {@link CqnService#EVENT_DELETE} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	void setResult(Iterable<? extends Map<String, ?>> result);
}
