/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.time.Instant;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(ExtensibilityService.EVENT_MODEL_CHANGED)
public interface ModelChangedEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
	 * {@link ExtensibilityService#EVENT_MODEL_CHANGED}
	 * @return the {@link ModelChangedEventContext}
	 */
	static ModelChangedEventContext create() {
		return EventContext.create(ModelChangedEventContext.class, null);
	}

	/**
	 * Sets the optional point in time the model changed or is known to have changed.
	 * The timestamp is used to only refresh the cached model in case it was cached previous to the given timestamp.
	 * If the timestamp is null, the model is always refreshed.
	 *
	 * @param timestamp the point in time the model changed or is known to have changed
	 */
	void setTimestamp(Instant timestamp);

	/**
	 * Returns the optional point in time the model changed or is known to have changed.
	 * The timestamp is used to only refresh the cached model in case it was cached previous to the given timestamp.
	 * If the timestamp is null, the model is always refreshed.
	 *
	 * @return the point in time the model changed or is known to have changed
	 */
	Instant getTimestamp();

}
