/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.Map;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

@EventName(DeploymentService.EVENT_SUBSCRIBE)
public interface SubscribeEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlaid with this interface. The event is set to be
	 * {@link DeploymentService#EVENT_SUBSCRIBE}
	 *
	 * @return the {@link SubscribeEventContext}
	 */
	static SubscribeEventContext create() {
		return EventContext.create(SubscribeEventContext.class, null);
	}

	@Override
	DeploymentService getService();

	/**
	 * @return the tenant ID
	 */
	String getTenant();

	/**
	 * Sets the tenant ID
	 *
	 * @param tenant the tenant ID
	 */
	void setTenant(String tenant);

	/**
	 * To get named and type safe access to this options map, it's possible to cast it to a specific implementation.
	 * For example, to access the SaaS registry payload it can be converted to SaasRegistrySubscriptionOptions:
	 * <pre>
	 * SaasRegistrySubscriptionOptions.create(context.getOptions());
	 * </pre>
	 *
	 * @return the optional additional options
	 */
	Map<String, Object> getOptions();

	/**
	 * Sets the optional additional options
	 *
	 * @param options the optional additional options
	 */
	void setOptions(Map<String, Object> options);

}
