/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.pdf;

import java.util.Collection;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.CdsName;

@CdsName("PdfService.PdfDocument")
public interface PdfDocumentDescription extends CdsData {
  String TITLE = "Title";

  String FORMAT = "Format";

  String PDFSTANDARD = "PDFStandard";

  String SIGNATURE = "Signature";

  String COVER_PAGE = "CoverPage";

  String TABLE_COLUMNS = "TableColumns";

  @CdsName(TITLE)
  String getTitle();

  @CdsName(TITLE)
  void setTitle(String title);

  @CdsName(FORMAT)
  Format getFormat();

  @CdsName(FORMAT)
  void setFormat(Format format);

  @CdsName(PDFSTANDARD)
  PDFStandard getPDFStandard();

  @CdsName(PDFSTANDARD)
  void setPDFStandard(PDFStandard pDFStandard);

  @CdsName(SIGNATURE)
  Signature getSignature();

  @CdsName(SIGNATURE)
  void setSignature(Signature signature);

  @CdsName(COVER_PAGE)
  Collection<String> getCoverPage();

  @CdsName(COVER_PAGE)
  void setCoverPage(Collection<String> coverPage);

  @CdsName(TABLE_COLUMNS)
  Collection<TableColumns> getTableColumns();

  @CdsName(TABLE_COLUMNS)
  void setTableColumns(Collection<TableColumns> tableColumns);

  static PdfDocumentDescription create() {
    return Struct.create(PdfDocumentDescription.class);
  }

  interface Format extends CdsData {
    String PAPER_SIZE = "PaperSize";

    String ORIENTATION = "Orientation";

    String FONT_SIZE = "FontSize";

    String FIT_TO_PAGE = "FitToPage";

    @CdsName(PAPER_SIZE)
    String getPaperSize();

    @CdsName(PAPER_SIZE)
    void setPaperSize(String paperSize);

    @CdsName(ORIENTATION)
    String getOrientation();

    @CdsName(ORIENTATION)
    void setOrientation(String orientation);

    @CdsName(FONT_SIZE)
    Integer getFontSize();

    @CdsName(FONT_SIZE)
    void setFontSize(Integer fontSize);

    @CdsName(FIT_TO_PAGE)
    FitToPage getFitToPage();

    @CdsName(FIT_TO_PAGE)
    void setFitToPage(FitToPage fitToPage);

    static Format create() {
      return Struct.create(Format.class);
    }

    interface FitToPage extends CdsData {
      String IS_ENABLED = "IsEnabled";

      String MINIMUM_FONT_SIZE = "MinimumFontSize";

      @CdsName(IS_ENABLED)
      Boolean getIsEnabled();

      @CdsName(IS_ENABLED)
      void setIsEnabled(Boolean isEnabled);

      @CdsName(MINIMUM_FONT_SIZE)
      Integer getMinimumFontSize();

      @CdsName(MINIMUM_FONT_SIZE)
      void setMinimumFontSize(Integer minimumFontSize);

      static FitToPage create() {
        return Struct.create(FitToPage.class);
      }
    }
  }

  interface PDFStandard extends CdsData {
    String DO_ENABLE_ACCESSIBILITY = "DoEnableAccessibility";

    String USE_PDFACONFORMANCE = "UsePDFAConformance";

    @CdsName(DO_ENABLE_ACCESSIBILITY)
    Boolean getDoEnableAccessibility();

    @CdsName(DO_ENABLE_ACCESSIBILITY)
    void setDoEnableAccessibility(Boolean doEnableAccessibility);

    @CdsName(USE_PDFACONFORMANCE)
    Boolean getUsePDFAConformance();

    @CdsName(USE_PDFACONFORMANCE)
    void setUsePDFAConformance(Boolean usePDFAConformance);

    static PDFStandard create() {
      return Struct.create(PDFStandard.class);
    }
  }

  interface Signature extends CdsData {
    String DO_SIGN = "DoSign";

    String REASON = "Reason";

    @CdsName(DO_SIGN)
    Boolean getDoSign();

    @CdsName(DO_SIGN)
    void setDoSign(Boolean doSign);

    @CdsName(REASON)
    String getReason();

    @CdsName(REASON)
    void setReason(String reason);

    static Signature create() {
      return Struct.create(Signature.class);
    }
  }

  interface TableColumns extends CdsData {
    String NAME = "Name";

    String HEADER = "Header";

    @CdsName(NAME)
    String getName();

    @CdsName(NAME)
    void setName(String name);

    @CdsName(HEADER)
    String getHeader();

    @CdsName(HEADER)
    void setHeader(String header);

    static TableColumns create() {
      return Struct.create(TableColumns.class);
    }
  }
}
