/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.runtime;

import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;

/**
 * A provider of the {@link FeatureTogglesInfo} for a {@link RequestContext}.
 */
public interface FeatureTogglesInfoProvider extends CdsProvider<FeatureTogglesInfoProvider> {

	/**
	 * @param userInfo The {@link UserInfo} of the {@link RequestContext}
	 * @param parameterInfo The {@link ParameterInfo} of the {@link RequestContext}
	 * @return The {@link FeatureTogglesInfo}
	 */
	FeatureTogglesInfo get(UserInfo userInfo, ParameterInfo parameterInfo);

}
