/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.cds;

import java.util.Map;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The specialized {@link EventContext} to be used for {@link CqnService#EVENT_UPDATE}
 */
@EventName(CqnService.EVENT_UPDATE)
public interface CdsUpdateEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlaid with this interface. The event is set to be {@link CqnService#EVENT_UPDATE}
	 * @param entityName the name of the entity
	 * @return the {@link CdsUpdateEventContext}
	 */
	static CdsUpdateEventContext create(String entityName) {
		return EventContext.create(CdsUpdateEventContext.class, entityName);
	}

	@Override
	CqnService getService();

	// IN
	/**
	 * @return the {@link CqnUpdate} statement
	 */
	CqnUpdate getCqn();

	/**
	 * Sets the {@link CqnUpdate} statement
	 * @param cqn the {@link CqnUpdate} statement
	 */
	void setCqn(CqnUpdate cqn);

	/**
	 * @return the CQN value sets, to enable batched {@link CqnUpdate} statements
	 */
	Iterable<Map<String, Object>> getCqnValueSets();

	/**
	 * Sets the CQN value sets, to enable batched {@link CqnUpdate} statements
	 * @param valueSets the CQN value sets
	 */
	void setCqnValueSets(Iterable<Map<String, Object>> valueSets);

	// OUT
	/**
	 * @return the {@link Result} of the {@link CqnService#EVENT_UPDATE} event
	 */
	Result getResult();

	/**
	 * Sets the result of the {@link CqnService#EVENT_UPDATE} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	void setResult(Iterable<? extends Map<String, ?>> result);
}
