/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.environment;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import com.sap.cds.docs.config.DocumentedProperty;

/**
 * This class is only used to generate Spring configuration metadata at compile time.
 * It should not be used at runtime, as Spring dependencies are not guaranteed to be available at runtime.
 * We can't place this class in our Spring Boot project, as the JavaDoc on {@link CdsProperties} is not available during generation there.
 */
@ConfigurationProperties
@DocumentedProperty
@lombok.Getter
@lombok.Setter
class SpringCdsProperties {

	/** Properties to configure CDS Services */
	@NestedConfigurationProperty
	@DocumentedProperty(header = false)
	private CdsProperties cds = new CdsProperties();

}
