/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.outbox;

import java.time.Instant;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * Describes the message stored and again published by the {@link OutboxService}
 */
@EventName("*")
public interface OutboxMessageEventContext extends EventContext {

	/**
	 * Creates a new {@link OutboxMessageEventContext}
	 * @param outboxEvent the outbox event with which the message is stored and again published by the {@link OutboxService}
	 * @return the {@link OutboxMessageEventContext}
	 */
	static OutboxMessageEventContext create(String outboxEvent) {
		OutboxMessageEventContext context = EventContext.create(outboxEvent, null).as(OutboxMessageEventContext.class);
		context.setIsInbound(false);
		return context;
	}

	/**
	 * Returns the inbound flag
	 * @return <code>true</code> if the message is again published by the {@link OutboxService} and <code>false</code> if the message should be stored.
	 */
	Boolean getIsInbound();

	/**
	 * Sets the inbound flag
	 * @param inbound <code>true</code> if the message is again published by the {@link OutboxService} and <code>false</code> if the message should be stored.
	 */
	void setIsInbound(boolean inbound);

	/**
	 * @return the timestamp when the message was stored in the outbox
	 */
	Instant getTimestamp();

	/**
	 * Sets the timestamp when the message was stored in the outbox.
	 * @param timestamp the timestamp
	 */
	void setTimestamp(Instant timestamp);

	/**
	 * @return the {@link OutboxMessage} stored and again published by the {@link OutboxService}
	 */
	OutboxMessage getMessage();

	/**
	 * Sets the {@link OutboxMessage} stored and again published by the {@link OutboxService}
	 * @param message the {@link OutboxMessage}
	 */
	void setMessage(OutboxMessage message);

}
