/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.runtime;

import com.sap.cds.services.request.ParameterInfo;

/**
 * A {@link ParameterInfoProvider} provides the {@link ParameterInfo} for a {@link com.sap.cds.services.request.RequestContext} if not provided explicitly.
 * By default, the runtime retrieves the data from the current HTTP request.
 */
public interface ParameterInfoProvider extends CdsProvider<ParameterInfoProvider> {

	/**
	 * Provides the {@link ParameterInfo}.
	 * @return	the {@link ParameterInfo} if available, {@code null} otherwise.
	 */
	ParameterInfo get();

}
