/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.cds;

import java.util.Map;

import com.sap.cds.Result;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The specialized {@link EventContext} to be used for {@link CqnService#EVENT_CREATE}
 */
@EventName(CqnService.EVENT_CREATE)
public interface CdsCreateEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlaid with this interface. The event is set to be {@link CqnService#EVENT_CREATE}
	 * @param entityName the name of the entity
	 * @return the {@link CdsCreateEventContext}
	 */
	static CdsCreateEventContext create(String entityName) {
		return EventContext.create(CdsCreateEventContext.class, entityName);
	}

	@Override
	CqnService getService();

	// IN
	/**
	 * @return the {@link CqnInsert} statement
	 */
	CqnInsert getCqn();

	/**
	 * Sets the {@link CqnInsert} statement
	 * @param cqn the {@link CqnInsert} statement
	 */
	void setCqn(CqnInsert cqn);

	// OUT
	/**
	 * @return the {@link Result} of the {@link CqnService#EVENT_CREATE} event
	 */
	Result getResult();

	/**
	 * Sets the result of the {@link CqnService#EVENT_CREATE} event
	 * @param result a {@link Result} or a list of Maps, which will be transformed into a {@link Result}
	 */
	void setResult(Iterable<? extends Map<String, ?>> result);
}
