/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.cds;

import com.sap.cds.reflect.CdsModel;

/**
 * A {@link RemoteService} is a {@link CqnService} that is backed by an actual service definition within the {@link CdsModel}.
 * It is a local representation of a service that is implemented by a different microservice / endpoint / backend,
 * which is usually available through some (network) protocol (e.g. HTTP, OData, etc.)
 */
public interface RemoteService extends CqnService {

	/**
	 * @return the definition of the service from the {@link CdsModel}
	 */
	com.sap.cds.reflect.CdsService getDefinition();

}
