/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.changeset;

import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.runtime.CdsRuntime;

public interface ChangeSetContextSPI extends ChangeSetContext, AutoCloseable {

	/**
	 * Creates a new {@link ChangeSetContextSPI} instance. The caller of this method is responsible for ensuring the context is closed.
	 * Consider using {@link CdsRuntime#changeSetContext()} instead if possible, as it automatically ensures to close the context.
	 *
	 * @return the newly created {@link ChangeSetContextSPI} instance.
	 *
	 * @see CdsRuntime#changeSetContext()
	 */
	static ChangeSetContextSPI open() {
		return CoreFactory.INSTANCE.createChangeSetContextSPI();
	}

	/**
	 * Registers a {@link ChangeSetMember} on the {@link ChangeSetContext}, to be used during {@link ChangeSetContext} is closed successfully or cancelled.
	 * It links a resource that should be completed or cancelled as part of this {@link ChangeSetContext}.
	 *
	 * @param member the {@link ChangeSetMember}
	 */
	void register(ChangeSetMember member);

	/**
	 * Returns {@code true} if a {@link ChangeSetMember} with the given name is already registered.
	 * This method indicates if the resource managed by the {@link ChangeSetMember} is already linked with this {@link ChangeSetContext}
	 *
	 * @param name the name of a {@link ChangeSetMember}
	 * @return {@code true} if a {@link ChangeSetMember} with the given name is already registered.
	 */
	boolean hasChangeSetMember(String name);
}
