/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.environment;

/**
 * A {@link ApplicationInfo} provides access to the application specific environment properties.
 * Application properties are usually defined by the platform in which the application is running.
 */
public interface ApplicationInfo {

	/**
	 * Provides the application name
	 *
	 * @return {@link String} the application name
	 */
	String getName();

	/**
	 * Provides the application ID.
	 *
	 * @return {@link String} the application ID
	 */
	String getId();

	/**
	 * Provides the application URL.
	 *
	 * @return the application URL
	 */
	String getUrl();
}
