package com.sap.cds.services.messages;

import org.slf4j.helpers.MessageFormatter;

import com.sap.cds.services.CoreFactory;
import com.sap.cds.services.runtime.CdsRuntime;

/**
 * {@link MessageLookup} provides all information to lookup localized messages via {@link CdsRuntime#getLocalizedMessage(String, Object[], java.util.Locale)} in different languages.
 */
public interface MessageLookup {

	/**
	 * Creates a new {@link MessageLookup}
	 * @param messageOrKey The formatting message, based on SLF4J's {@link MessageFormatter}, or a key to a message format in the resource bundles.
	 * @param args The argument objects for the format string.
	 * @return the {@link MessageLookup}
	 */
	static MessageLookup create(String messageOrKey, Object[] args) {
		return CoreFactory.INSTANCE.createMessageLookup(messageOrKey, args);
	}

	/**
	 * @return The formatting message, based on SLF4J's {@link MessageFormatter}, or a key to a message format in the resource bundles.
	 */
	String getMessageOrKey();

	/**
	 * @return The argument objects for the format string.
	 */
	Object[] getArgs();

}
