/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.mt;

import java.util.List;
import java.util.Set;

import com.sap.cds.services.EventContext;
import com.sap.cds.services.EventName;

/**
 * The {@link EventContext} for the {@link TenantProviderService#EVENT_READ_TENANTS} event.
 */
@EventName(TenantProviderService.EVENT_READ_TENANTS)
public interface ReadTenantsEventContext extends EventContext {

	/**
	 * Creates an {@link EventContext} already overlaid with this interface. The event is set to be {@link TenantProviderService#EVENT_READ_TENANTS}
	 * @return the {@link ReadTenantsEventContext}
	 */
	static ReadTenantsEventContext create() {
		return EventContext.create(ReadTenantsEventContext.class, null);
	}

	@Override
	TenantProviderService getService();

	/**
	 * @return A set of fields to retain from the {@link TenantInfo} object.
	 */
	Set<String> getFields();

	/**
	 * @param fields A set of fields to retain from the {@link TenantInfo} objects.
	 */
	void setFields(Set<String> fields);

	/**
	 * @return A list of tenant identifiers that are currently subscribed to this application.
	 */
	List<TenantInfo> getResult();

	/**
	 * @param result A list of tenant identifiers that are currently subscribed to this application.
	 */
	void setResult(List<TenantInfo> result);

}
