/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.services.persistence;

import com.sap.cds.CdsDataStore;
import com.sap.cds.services.cds.CqnService;
import com.sap.cds.services.handler.Handler;

/**
 * The interface defining the consumption API of the {@link PersistenceService}.
 * The {@link PersistenceService} is basically a wrapper around a {@link CdsDataStore}, providing extensibility via {@link Handler}.
 */
public interface PersistenceService extends CqnService {

	/**
	 * The {@link PersistenceService} wrapping the primary SQL database uses this name
	 */
	String DEFAULT_NAME = "PersistenceService$Default";

}
